﻿// console_app_main.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "console_app_main.h"
#include "Command_Parse.h"
#include <windows.h>


MainControl_Class g_main_control;


void print_message()
{	
	cout << "1. create device " << endl;
	cout << "2. Show  Information " << endl;
	cout << "3. Record  Start|Stop  Channel(" << 1 << "-" << MAX_CHANNEL_NUM << ")[Multi-Ch] [-avi|-mp4] [-gpu]" << endl;
	cout << "4. Share  Record  Start|Change|Stop  Channel(" << 1 << "-" << MAX_CHANNEL_NUM << ")  [-avi|-mp4] [-gpu]" << endl;
	cout << "5: Snapshot  BMP|JPG  Channel(" << 1 << "-" << MAX_CHANNEL_NUM << ")[Multi-Ch]  " << endl;
	cout << "6: Config  Input  Video|Audio Channel(" << 1 << "-" << MAX_CHANNEL_NUM << ")[Multi-Ch]  " << endl;
	cout << "7: Exit " <<endl;	
}


void list_video_foarmat()
{	
	for( int i=0; i< MAX_VIDEO_INPUT_NUM; i++)
	{
		printf("[%d] %s\n",i, input_video_mapping[i]);
	}
	printf("[%d] exit\n", MAX_VIDEO_INPUT_NUM);
	
}


void list_audio_foarmat()
{	
	for( int i=0; i< MAX_AUDIO_INPUT_NUM; i++)
	{
		printf("[%d] %s\n",i, input_audio_mapping[i]);
	}
	printf("[%d] exit\n", MAX_AUDIO_INPUT_NUM);
	
}


void MainControl_Class::show_information()
{	
	printf(" [Ch]     [Status]        [Resolution]     [Video Input]     [Audio Input]   \n");	

	for(int ch_idx=0; ch_idx < MAX_CHANNEL_NUM; ch_idx++) {

		if(m_capture_card[ch_idx].m_status.m_bNoSignal_flag == false) {
		 
			if(m_capture_card[ch_idx].m_status.m_ShareRecord_flag ){
				printf("   %d    ShRecording   %4u x %4u %d fps      %5s         %s\n",  ch_idx+1 , m_capture_card[ch_idx].m_nVideoWidth, m_capture_card[ch_idx].m_nVideoHeight, (int)m_capture_card[ch_idx].m_dVideoFrameRate, 
																				         input_video_mapping[m_capture_card[ch_idx].m_nVideoInput], input_audio_mapping[m_capture_card[ch_idx].m_nAudioInput] );

			} if(m_capture_card[ch_idx].m_status.m_bIsRecord_flag ){
				printf("   %d      Recording   %4u x %4u %d fps      %5s         %s\n",  ch_idx+1 , m_capture_card[ch_idx].m_nVideoWidth, m_capture_card[ch_idx].m_nVideoHeight, (int)m_capture_card[ch_idx].m_dVideoFrameRate, 
																				         input_video_mapping[m_capture_card[ch_idx].m_nVideoInput], input_audio_mapping[m_capture_card[ch_idx].m_nAudioInput] );

			} else {
				printf("   %d      Normal      %4u x %4u %d fps      %5s         %s\n",  ch_idx+1 , m_capture_card[ch_idx].m_nVideoWidth, m_capture_card[ch_idx].m_nVideoHeight, (int)m_capture_card[ch_idx].m_dVideoFrameRate, 
																				         input_video_mapping[m_capture_card[ch_idx].m_nVideoInput], input_audio_mapping[m_capture_card[ch_idx].m_nAudioInput] );

			}

		} else {			
			printf("   %d      No Signal     \n",ch_idx + 1);
		}
	}
}



QRETURN on_process_format_changed_func( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, 
									    BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  
								        ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CaptureCard *m_Cap = (CaptureCard*) pUserData;

	m_Cap->m_nVideoInput = nVideoInput;

	m_Cap->m_nAudioInput = nAudioInput;

	m_Cap->m_nVideoWidth = nVideoWidth;

	m_Cap->m_nVideoHeight = nVideoHeight;

	m_Cap->m_dVideoFrameRate = dVideoFrameRate;

	if( nVideoInput == 0 && nVideoHeight == 0 && dVideoFrameRate == 0.0 && nAudioChannels == 0) {
		m_Cap->m_status.m_bNoSignal_flag = true;
	} else {
		m_Cap->m_status.m_bNoSignal_flag = false;
	}

	return QCAP_RT_OK;
}


QRETURN on_process_no_signal_detected_func( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CaptureCard *m_Cap = (CaptureCard*) pUserData;

	m_Cap->m_nVideoWidth = 0;

	m_Cap->m_nVideoHeight = 0;

	m_Cap->m_status.m_bNoSignal_flag = true;

	return QCAP_RT_OK;
}


QRETURN on_process_signal_removed_func( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CaptureCard *m_Cap = (CaptureCard*) pUserData;

	m_Cap->m_nVideoWidth = 0;

	m_Cap->m_nVideoHeight = 0;

	m_Cap->m_status.m_bNoSignal_flag = true;

	return QCAP_RT_OK;
}


QRETURN on_process_preview_video_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG FrameBufferLen, PVOID pUserData)
{	
	CaptureCard *m_Cap = (CaptureCard*) pUserData;
	
	if ( m_Cap->m_status.m_ShareRecord_flag == true ) {
		
		QRESULT ret = QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YV12, m_Cap->m_nVideoWidth, m_Cap->m_nVideoHeight, pFrameBuffer, FrameBufferLen );
	}

    return QCAP_RT_OK;
}


QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CaptureCard *m_Cap = (CaptureCard*) pUserData;

	if ( m_Cap->m_status.m_ShareRecord_flag == true ) {

		QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
	}

	return QCAP_RT_OK;
}


QRETURN on_process_video_hardware_encoder_buffer( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, BOOL bIsKeyFrame, PVOID pUserData)
{
    return QCAP_RT_OK;
}


int MainControl_Class::init_capture_card_func()
{
	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ){

		m_capture_card[ch_idx].m_hVideoDevice = NULL;

		m_capture_card[ch_idx].m_nVideoWidth = 0;

		m_capture_card[ch_idx].m_nVideoHeight = 0;

		m_capture_card[ch_idx].m_nVideoInput = 0;

		m_capture_card[ch_idx].m_nAudioInput = 0;

		m_capture_card[ch_idx].m_dVideoFrameRate = 0;

		m_capture_card[ch_idx].m_status.m_bIsRecord_flag = false;

		m_capture_card[ch_idx].m_status.m_bNoSignal_flag = true;

		m_capture_card[ch_idx].m_status.m_ShareRecord_flag = false;

		m_capture_card[ch_idx].m_errno = QCAP_CREATE( "QP0203 PCI", ch_idx, NULL, &m_capture_card[ch_idx].m_hVideoDevice, 1 );		

		if(m_capture_card[ch_idx].m_errno != 0){ continue; }				

		printf(" create Ch%d \n",ch_idx+1);

		// Set Callback func		
	
		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_capture_card[ch_idx].m_hVideoDevice, on_process_format_changed_func, (PVOID)&m_capture_card[ch_idx]);

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_capture_card[ch_idx].m_hVideoDevice, on_process_no_signal_detected_func, (PVOID)&m_capture_card[ch_idx]);

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_capture_card[ch_idx].m_hVideoDevice, on_process_signal_removed_func, (PVOID)&m_capture_card[ch_idx]);

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_capture_card[ch_idx].m_hVideoDevice, on_process_preview_video_buffer, (PVOID)&m_capture_card[ch_idx]);

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_capture_card[ch_idx].m_hVideoDevice, on_process_preview_audio_buffer, (PVOID)&m_capture_card[ch_idx]);

		QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_capture_card[ch_idx].m_hVideoDevice, 0, on_process_video_hardware_encoder_buffer, (PVOID)&m_capture_card[ch_idx]);

		QCAP_SET_VIDEO_INPUT( m_capture_card[ch_idx].m_hVideoDevice, QCAP_INPUT_TYPE_AUTO );
	
		QCAP_SET_AUDIO_INPUT( m_capture_card[ch_idx].m_hVideoDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

		QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_capture_card[ch_idx].m_hVideoDevice, 0,QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF, 0, 0);

		m_capture_card[ch_idx].m_errno = QCAP_RUN(m_capture_card[ch_idx].m_hVideoDevice);	

	}

	m_share_record_idx = DEF_SHARERECORD_UNUSE;	

	return RETURN_OK;
}


int MainControl_Class::file_record_start_func( struct command_s command_data)
{
	char video_name[16];

	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ){

		if(m_capture_card[ch_idx].m_hVideoDevice != NULL)
		{		
			if (m_capture_card[ch_idx].m_status.m_bIsRecord_flag == true || command_data.execute_channel_flag[ch_idx] == false) continue;

			m_capture_card[ch_idx].m_errno = QCAP_SET_AUDIO_RECORD_PROPERTY( m_capture_card[ch_idx].m_hVideoDevice, 0,  QCAP_ENCODER_TYPE_SOFTWARE, get_audio_format_by_mapping[command_data.execute_format] );  //MP4 use AAC audio

			if(m_capture_card[ch_idx].m_errno != 0){ continue; }

			if( command_data.execute_enable_gpu == true) {
				m_capture_card[ch_idx].m_errno = QCAP_SET_VIDEO_RECORD_PROPERTY( m_capture_card[ch_idx].m_hVideoDevice, 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR,
																				 8000, 12*1024*1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );  
			} else {
				m_capture_card[ch_idx].m_errno = QCAP_SET_VIDEO_RECORD_PROPERTY( m_capture_card[ch_idx].m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR,
																				 8000, 12*1024*1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );  
			}
			if(m_capture_card[ch_idx].m_errno != 0){ continue; }

		
			if (command_data.execute_format == CONFIG_FORMAT_MP4) {
				sprintf(video_name,"Record_%d.mp4",ch_idx);
			} else {
				sprintf(video_name,"Record_%d.avi",ch_idx);
			}

			m_capture_card[ch_idx].m_errno = QCAP_START_RECORD(m_capture_card[ch_idx].m_hVideoDevice, 0 , video_name);

			if(m_capture_card[ch_idx].m_errno != 0){ continue; }

			m_capture_card[ch_idx].m_status.m_bIsRecord_flag = true;
		}		
	}

	// Dbg Message	
	 
	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ){

		if(command_data.execute_channel_flag[ch_idx] == false) continue;

		if(m_capture_card[ch_idx].m_errno == 0){
     		printf(" Ch %d Recording ...\n",ch_idx + 1);
		}else {
			printf(" Ch %d Fail to Start Record (%d)...\n", ch_idx + 1, m_capture_card[ch_idx].m_errno);
		}	
	}
	
	return RETURN_OK;
}


int MainControl_Class::file_record_stop_func(struct command_s command_data)
{
	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ){

		if(m_capture_card[ch_idx].m_hVideoDevice != NULL)
		{
			if(command_data.execute_channel_flag[ch_idx] == false) continue;

			m_capture_card[ch_idx].m_errno = QCAP_STOP_RECORD(m_capture_card[ch_idx].m_hVideoDevice, 0 );

			m_capture_card[ch_idx].m_status.m_bIsRecord_flag = false;
		}
	}

	// Dbg Message
	
	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ){

		if(command_data.execute_channel_flag[ch_idx] == false) continue;

		if(m_capture_card[ch_idx].m_errno == 0){
     		printf(" Ch %d Stop Recording ...\n",ch_idx + 1);
		}else {
			printf(" Ch %d Fail to Stop Record (%d)...\n", ch_idx + 1, m_capture_card[ch_idx].m_errno);
		}	
	}
	
	return RETURN_OK;
}


int MainControl_Class::share_record_start_func(struct command_s command_data)
{
	int ch_idx;
	for( ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ) {
		
		if(command_data.execute_channel_flag[ch_idx] == true) {		
			break;
		}
	}

	if( m_share_record_idx != DEF_SHARERECORD_UNUSE) {

		// share record already is exist, try to change channel
		m_capture_card[m_share_record_idx].m_status.m_ShareRecord_flag = false;		
		m_share_record_idx = ch_idx;
		m_capture_card[ch_idx].m_status.m_ShareRecord_flag = true;

	} else {

		if( command_data.execute_enable_gpu == true) {
		
			QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, 
												  m_capture_card[ch_idx].m_nVideoWidth, m_capture_card[ch_idx].m_nVideoHeight, m_capture_card[ch_idx].m_dVideoFrameRate,
										          QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, NULL, 1 );
		} else {

			QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, 
											      m_capture_card[ch_idx].m_nVideoWidth, m_capture_card[ch_idx].m_nVideoHeight, m_capture_card[ch_idx].m_dVideoFrameRate, 
											      QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, NULL, 1 );
		}

		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, get_audio_format_by_mapping[command_data.execute_format], 2, 16, 48000 );

		if (command_data.execute_format == CONFIG_FORMAT_MP4) {
			QRESULT ret = QCAP_START_SHARE_RECORD( 0, "ShareRecord.mp4" );
		} else {
			QRESULT ret = QCAP_START_SHARE_RECORD( 0, "ShareRecord.avi" );
		}		

		m_share_record_idx = ch_idx;
		m_capture_card[ch_idx].m_status.m_ShareRecord_flag = true;
	}

	return RETURN_OK;
}


int MainControl_Class::share_record_stop_func()
{
	
	if( m_share_record_idx != DEF_SHARERECORD_UNUSE){

		QCAP_STOP_SHARE_RECORD( 0 );

		m_share_record_idx = DEF_SHARERECORD_UNUSE;
	}
	 
	return RETURN_OK;
}


int MainControl_Class::snapshot_jpg_func(struct command_s command_data)
{
	char image_name[16];
	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ){

		if(m_capture_card[ch_idx].m_hVideoDevice != NULL)
		{
			if(command_data.execute_channel_flag[ch_idx] == false) continue;

			sprintf(image_name,"PITURE_%d.JPG",ch_idx + 1);
			m_capture_card[ch_idx].m_errno = QCAP_SNAPSHOT_JPG( m_capture_card[ch_idx].m_hVideoDevice, image_name, 80 );
		}
	}

	return RETURN_OK;
}


int MainControl_Class::snapshot_bmp_func(struct command_s command_data)
{
	char image_name[16];
	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ){

		if(m_capture_card[ch_idx].m_hVideoDevice != NULL)
		{
			if(command_data.execute_channel_flag[ch_idx] == false) continue;

			sprintf(image_name,"PITURE_%d.BMP",ch_idx + 1);
			m_capture_card[ch_idx].m_errno = QCAP_SNAPSHOT_BMP( m_capture_card[ch_idx].m_hVideoDevice, image_name );
		}

	}

	return RETURN_OK;
}


int MainControl_Class::set_video_input_func(struct command_s command_data)
{
	int res;
	char input[32];

	list_video_foarmat(); 
	
	printf("Please Input [0-7] :"); 	
	cin >> input;
	res = atoi(input);

	if( res >= 0 && res < MAX_VIDEO_INPUT_NUM ) {

		for(int ch_idx=0; ch_idx<=0; ch_idx++) {

			if(m_capture_card[ch_idx].m_hVideoDevice != NULL)
			{
				if(command_data.execute_channel_flag[ch_idx] == false) continue;
			
				int rt = QCAP_SET_VIDEO_INPUT( m_capture_card[ch_idx].m_hVideoDevice, res );
			}

		}

	} else if (res == 7) {

		printf("exit\n");

	} else {
		printf("Invaild Command\n");
	}

	return RETURN_OK;
}


int MainControl_Class::set_audio_input_func(struct command_s command_data)
{
	int res;
	char input[32];

	list_audio_foarmat(); 
	printf("Please Input [0-4] :"); 
	cin >> input;

	if( res >= 0 && res < MAX_AUDIO_INPUT_NUM ) {

		for(int ch_idx=0; ch_idx<=0; ch_idx++) {

			if(m_capture_card[ch_idx].m_hVideoDevice != NULL)
			{	
				if(command_data.execute_channel_flag[ch_idx] == false) continue;

				QCAP_SET_AUDIO_INPUT( m_capture_card[ch_idx].m_hVideoDevice, res );	
			}
		
		}
				
	} else if (res == 4) {

		printf("exit\n");

	} else {
		printf("Invaild Command\n");
	}

	return RETURN_OK;
}




void MainControl_Class::OnDestroy()
{

	share_record_stop_func();

	for( int ch_idx=0; ch_idx<MAX_CHANNEL_NUM; ch_idx++ ) {

		if(m_capture_card[ch_idx].m_hVideoDevice!=NULL)
		{		
			if( m_capture_card[ch_idx].m_status.m_bIsRecord_flag == false ) {

				QCAP_STOP_RECORD(m_capture_card[ch_idx].m_hVideoDevice, 0 );
			}

			QCAP_STOP(m_capture_card[ch_idx].m_hVideoDevice);

			QCAP_DESTROY(m_capture_card[ch_idx].m_hVideoDevice);

			m_capture_card[ch_idx].m_hVideoDevice = NULL;

			printf("destroy ch%d \n", ch_idx+1);
		}
	}

	return;
}


void main_process(struct command_s command_data){


	switch (command_data.execute_command)
	{
		// Show Information include of resolution, video input and audio input
		case 0:
			g_main_control.show_information(); break;		

		//  Record Start 
		case 1:	
			g_main_control.file_record_start_func(command_data); break;

		//  Record Stop
		case 2: 
			g_main_control.file_record_stop_func(command_data); break;

		//  Share Record Start or Change
		case 3:
		case 4:
			g_main_control.share_record_start_func(command_data); break;			

		//  Share Record Stop
		case 5:
			g_main_control.share_record_stop_func(); break;			

		//  Snapshot JPG Image
		case 6:
			g_main_control.snapshot_jpg_func(command_data); break;

		//  Snapshot BMP Image
		case 7:
			g_main_control.snapshot_bmp_func(command_data); break;
			
		//  Set Video Input 			
		case 8:
			g_main_control.set_video_input_func(command_data); break;

		//  Set Audio Input
		case 9:
			g_main_control.set_audio_input_func(command_data); break;

		//  Exit
		case 10:
			g_main_control.OnDestroy(); break;

		//  create device
		case 11:
			g_main_control.init_capture_card_func(); break;

		default :
			break;
	}
}


int _tmain(int argc, _TCHAR* argv[])
{

	HRESULT hr = CoInitialize( NULL );
	HWND console = GetConsoleWindow();
	RECT r;
	GetWindowRect(console, &r);
	MoveWindow(console, r.left, r.top, 1000, 600, TRUE);

	command_t command_data;
	char user_input[256];
		
	while(1){
		
		print_message();

		memset(user_input, 0x00, sizeof(user_input));
		memset(&command_data, 0x00, sizeof(command_t));

		
		cout << " Command Input : ";
		std::cin.getline (user_input, sizeof(user_input));
		cout << endl;

		command_data = Command_parse_func(user_input, sizeof(user_input));

		if( command_data.execute_status == true){

			main_process(command_data);

		} else {

			printf("Invaild Command\n");
		}
		_sleep(1000);
		cout << endl;
		cout << endl;
	}
	

	CoUninitialize();

	return 0;
}

